<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Nineteen
 * @since 1.0.0
 */
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
 <header class="main-header" data-aos="fade-up" data-aos-once="true">
		<div class="top_header">
			<div class="container">
				<div class="row center_item">
					<div class="col">
						<a class="navbar-brand" href="<?php echo get_home_url(); ?>"><img src="<?php if(function_exists('get_field') && get_field('header_logo','option')){ the_field('header_logo','option'); } ?>" alt="North County Family Medicine"/></a>
					</div>
					<div class="col text-right">
						<div class="d-inline-flex center_item">
						<ul class="top-menu d-none d-lg-block">							
							<li>
								<span class="icon"><i class="far fa-envelope"></i></span>
								<span class="content">Email <a href="mailto:<?php if(function_exists('get_field') && get_field('email','option')){ the_field('email','option'); } ?>"><?php if(function_exists('get_field') && get_field('email','option')){ the_field('email','option'); } ?></a></span>
							</li>
						</ul>
						<ul class="cart_user">
							<li><a href="<?php echo get_home_url(); ?>/<?php if(function_exists('get_field') && get_field('account_icon_link','option')){ the_field('account_icon_link','option'); } ?>"><i class="far fa-user"></i></a></li>
							<li><a href="<?php echo wc_get_cart_url(); ?>"><i class="fas fa-shopping-cart"></i><span class="pro_count"><?php echo sprintf ( _n( '%d', '%d', WC()->cart->get_cart_contents_count() ), WC()->cart->get_cart_contents_count() ); ?> </span></a></li>
						</ul>
						</div>
					</div>
				</div>
			</div>
		
		</div>
		<div class="main_nav">
        <div class="container">
			<nav class="navbar navbar-expand-lg">
				
				<button class="navbar-toggler collapsed w-100 text-left" type="button" data-toggle="collapse" data-target="#main_nav" aria-controls="main_nav" aria-expanded="false" aria-label="Toggle navigation"><span>Menu</span><i class="fas fa-bars float-right"></i></button>

			  <div class="navbar-collapse collapse" id="main_nav" style="">
				<?php
					wp_nav_menu( array(
						'theme_location'    => 'menu-1',
						'depth'             => 3,
						'container'         => 'div',
						'container_class'   => '',
						'menu_class'        => 'navbar-nav mr-auto',
						'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
						'walker'            => new wp_bootstrap_navwalker())
					);
				?>
				<ul class="social_icon">
					<li><a href="<?php if(function_exists('get_field') && get_field('facebook_link','option')){ the_field('facebook_link','option'); } ?>"><i class="fab fa-facebook-f"></i></a></li>
					<li><a href="<?php if(function_exists('get_field') && get_field('twitter_link','option')){ the_field('twitter_link','option'); } ?>"><i class="fab fa-twitter"></i></a></li>
					<li><a href="<?php if(function_exists('get_field') && get_field('instagram_link','option')){ the_field('instagram_link','option'); } ?>"><i class="fab fa-instagram"></i></a></li>
					<li><a href="<?php if(function_exists('get_field') && get_field('yelp_link','option')){ the_field('yelp_link','option'); } ?>"><i class="fab fa-yelp"></i></a></li>
				</ul>
			  </div>
			</nav>
        </div>
		</div>
    </header>