<?php
/**
Template Name: Blog
 */

get_header(); ?>

<?php  if(have_posts()) : ?>
		<?php while(have_posts()) : the_post(); ?>
		
<section class="inner-banner">
	<div class="container">
		<div class="row">
		<div class="banner-section">
			<?php $imageArray = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),"full"); ?>
			
			<?php if(isset($imageArray[0]) && !empty($imageArray[0])) : ?>
				<img src="<?php echo $imageArray[0]; ?>" class="img-responsive">
			<?php else: ?>
				<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/blog-bg.jpg" class="img-responsive">
			<?php endif; ?>
 			
			<div class="banner-content-area">
				<div class="container">
					<div class="row">
						<div class="col-md-12">
							<?php if(function_exists("get_field") && get_field("banner_heading_1")) : ?>
								<h4><?php the_field("banner_heading_1"); ?></h4>
							<?php endif ?>						
							
							<h2><?php the_title(); ?></h2>
							<!--<a href="javascript:void(0)" class="call-2-more">Schedule a <span>Appointment</span></a>-->
							<nav aria-label="breadcrumb" class="float-right">
								<ol class="breadcrumb">
									<li class="breadcrumb-item"><a href="<?php bloginfo("url"); ?>">Home</a></li>
									<li class="breadcrumb-item active" aria-current="page"><?php the_title(); ?></li>
								</ol>
							</nav>
						</div>
					</div>            
				</div>                
			</div>
		</div>
		</div>
	</div>
</section>

 <div class="blog-main art-bacground" data-aos="fade-up" data-aos-once="true">
		<div class="container">
			<div class="row">
				<?php
      $id=get_the_ID();
	$the_query = new WP_Query(array(
									'post_type' => 'post',
									'posts_per_page' =>12));
									while ( $the_query->have_posts() ) : $the_query->the_post(); ?> 
				<div class="row blog_item center_item">
					<div class="col-md-5">							
					<img src="<?php echo get_first_image(); ?>" class="w-100"  />
					</div>
					<div class="col-md-7">
						<div class="inner_content">
							<h5><?php echo get_the_date( 'D M j' );?> , BY  <?php the_author();?> <span class="border_line"></span></h5>
							<a href="<?php the_permalink();?>"><h2><?php the_title();?></h2></a>
							 <p><?php echo wp_trim_words( get_the_content(), 100, '...' );?></p>
							 <a class="r-more custom_btn_style" href="<?php the_permalink();?>">Read More</a>
						</div>
					</div>
				</div>
			<?php endwhile; wp_reset_postdata();?>			
				
			</div>
		</div>
	</div>
	
	
	
		<?php endwhile; ?>
	<?php endif; ?>	
 
<?php get_footer(); ?>