<?php
/**
Template Name: About us
*/

get_header(); ?>	

<section class="inner-banner">
	<div class="container">
		<div class="row">
			<?php while ( have_posts() ) : the_post(); ?>
			<div class="banner-section">
				<?php $imageArray = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),"full"); ?>
				
				<?php if(isset($imageArray[0]) && !empty($imageArray[0])) : ?>
					<img src="<?php echo $imageArray[0]; ?>" class="img-responsive">
				<?php else: ?>
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/about-bg.jpg" class="img-responsive">
				<?php endif; ?>
	 			
				<div class="banner-content-area">
					<div class="container">
						<div class="row">
							<div class="col-md-12">
								<?php if(function_exists("get_field") && get_field("banner_heading_1")) : ?>
									<h4><?php the_field("banner_heading_1"); ?></h4>
								<?php endif ?>						
								
								<h2><?php the_title(); ?></h2>
								<!--<a href="javascript:void(0)" class="call-2-more">Schedule a <span>Appointment</span></a>-->
								<nav aria-label="breadcrumb" class="float-right">
									<ol class="breadcrumb">
										<li class="breadcrumb-item"><a href="<?php bloginfo("url"); ?>">Home</a></li>
										<li class="breadcrumb-item active" aria-current="page"><?php the_title(); ?></li>
									</ol>
								</nav>
							</div>
						</div>            
					</div>                
				</div>
			</div>
		</div>
	</div>
</section>

		<section class="inner-content art-bacground">
			<div class="container">
				<div class="row center_item">
					<div class="col-md-4"><img src="<?php  if( function_exists('get_field')) {	 echo the_field('about_image');} ?>" class="img-responsive comman-shadow-pic"></div>
					<div class="col-md-8">
						<?php the_content();?>
					</div>
				</div>
			</div><!-- .container -->
		</section><!-- .inner-content -->
	<?php endwhile; ?>

<?php get_footer(); ?>
