<?php
/**
Template Name: Contact Us
*/

get_header(); ?>	

<section class="inner-banner">
	<div class="container">
		<div class="row">
			<?php while ( have_posts() ) : the_post(); ?>
			<div class="banner-section">
				<?php $imageArray = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),"full"); ?>
				
				<?php if(isset($imageArray[0]) && !empty($imageArray[0])) : ?>
					<img src="<?php echo $imageArray[0]; ?>" class="img-responsive">
				<?php else: ?>
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/contact-us-bg.jpg" class="img-responsive">
				<?php endif; ?>
	 			
				<div class="banner-content-area">
					<div class="container">
						<div class="row">
							<div class="col-md-12">
								<?php if(function_exists("get_field") && get_field("banner_heading_1")) : ?>
									<h4><?php the_field("banner_heading_1"); ?></h4>
								<?php endif ?>						
								
								<h2><?php the_title(); ?></h2>
								<!--<a href="javascript:void(0)" class="call-2-more">Schedule a <span>Appointment</span></a>-->
								<nav aria-label="breadcrumb" class="float-right">
									<ol class="breadcrumb">
										<li class="breadcrumb-item"><a href="<?php bloginfo("url"); ?>">Home</a></li>
										<li class="breadcrumb-item active" aria-current="page"><?php the_title(); ?></li>
									</ol>
								</nav>
							</div>
						</div>            
					</div>                
				</div>
			</div>
		</div>
	</div>
</section>

		<section class="inner-content art-bacground">
			<div class="container">
				<div class="row center_item">
					<!--Section: Contact v.2-->
					<div class="mb-4 contact-form">
					    <!--Section heading-->
					    <h2 class="h1-responsive font-weight-bold text-center my-4">Contact us</h2>
					    <!--Section description-->
					    <p class="text-center w-responsive mx-auto mb-5"><?php  if( function_exists('get_field')) {	 echo the_field('form_content');} ?></p>

					    <div class="row">
					        <!--Grid column-->
					        <div class="col-md-9 mb-md-0 mb-5">
					            <div id="contact-form" >
								<?php $contactform = get_field('contact_us_form_shortcode');?>
								<?php echo do_shortcode($contactform);?>
								

					            </div>
					        </div>
					        <!--Grid column-->

					        <!--Grid column-->
					        <div class="col-md-3 text-center">
					            <ul class="list-unstyled mb-0">
					               <!--  <li><i class="fas fa-map-marker-alt fa-2x"></i>
					                    <p> <?php  //if( function_exists('get_field')) {	 echo the_field('address_info');} ?></p>
					                </li>

					                <li><i class="fas fa-phone mt-4 fa-2x"></i>
					                    <p><?php  //if( function_exists('get_field')) {	 echo the_field('phone_info');} ?></p>
					                </li> -->

					                <li><i class="fas fa-envelope mt-4 fa-2x"></i>
					                    <p><?php  if( function_exists('get_field')) {	 echo the_field('email_info');} ?></p>
					                </li>
					            </ul>
					        </div>
					        <!--Grid column-->
					    </div>
					</div>
					<!--Section: Contact v.2-->
				</div>
			</div><!-- .container -->
		</section><!-- .inner-content -->
	<?php endwhile; ?>

<?php get_footer(); ?>
