<?php
/**
Template Name: Home
 */

get_header(); ?>

<?php  if(have_posts()) : ?>
		<?php while(have_posts()) : the_post(); ?>
		
		
<div class="slider">
		<div class="container">
			<div class="row center_item">
				<div class="col-md-6" data-aos="fade-right" data-aos-once="true">
					<img src="<?php  if( function_exists('get_field')) {	 echo the_field('jack_paschall’s_art_image');} ?>" class="w-100"/>
				</div>
				<div class="col-md-6 text-right" data-aos="fade-left" data-aos-once="true">
					<h1><?php  if( function_exists('get_field')) {	 echo the_field('jack_paschall’s_art_title');} ?></h1>
					<?php  if( function_exists('get_field')) {	 echo the_field('jack_paschall’s_art_content');} ?>
					<a href="<?php  if( function_exists('get_field')) {	 echo the_field('jack_paschall’s_art_link');} ?>" class="btn custom_btn_style">Get In Touch</a>
				</div>
			</div>
		</div>
	</div>
	
	<div class="about_block gray-bg" data-aos="fade-up" data-aos-once="true">
		<div class="container">
			<div class="row">
				<div class="col-md-12 text-center">
					<div class="inner_content">
						<h2><?php  if( function_exists('get_field')) {	 echo the_field('about_us_title');} ?></h2>
						<?php  if( function_exists('get_field')) {	 echo the_field('about_us_content');} ?>
						<a href="<?php  if( function_exists('get_field')) {	 echo the_field('about_us_read_more_link');} ?>" class="btn custom_btn_style">Read More</a>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<div class="portfolio_block" data-aos="fade-down" data-aos-once="true">
		<div class="container">
			<div class="row mb-3">
				<div class="col-md-12 text-center">
					<div class="title_block">
						<h2><?php  if( function_exists('get_field')) {	 echo the_field('our_portfolio_title');} ?></h2>
						<?php  if( function_exists('get_field')) {	 echo the_field('our_portfolio_content');} ?>
					</div>
				</div>
			</div>

			<div id="portfolio" class="carousel slide" data-ride="carousel" data-interval="0">
				<!-- Wrapper for carousel items -->
				<div class="carousel-inner">
				
				<?php
					  $id=get_the_ID();
					$the_query = new WP_Query(array(
													'post_type' => 'portfolio',
																																						
													));
													 $counter = 0;
										
									while ( $the_query->have_posts() ) : $the_query->the_post(); ?> 
									 <?php if ( $counter%4 == 0 ): ?>
					<div class="item carousel-item <?php if ( $counter == 0 ): ?>active<?php endif; ?>">
						<div class="row">
							 <?php endif; ?>	
							<div class="col-md-3 text-center">
								<div class="portfolio_item">
									<div class="portfolio_img">
										<?php $imageArray = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),"full"); ?>
								<?php if(isset($imageArray[0]) && $imageArray[0]) : ?>
								 <a href="<?php echo $imageArray[0]; ?>" class="fancybox" rel="ligthbox">
									<img src="<?php echo $imageArray[0]; ?>" class="w-100 zoom img-fluid"  />
									</a>
								<?php endif; ?> 
										
									</div>
									<div class="portfolio_content">
										<h3><?php the_title();?></h3>
										<p><?php echo wp_trim_words( get_the_content(), 25, '...' );?></p>
									</div>
								</div>
							</div>
							<?php $counter++; ?>
							 <?php if ( $counter%4 == 0 ):?>
						
						
						</div>
					</div>
					 <?php endif; ?>
					 <?php wp_reset_postdata(); ?>
        <?php endwhile;   ?>
				</div>
			</div>
			
			<div class="row arrows">
				<div class="col-md-12 text-center">
					<!-- Carousel controls -->
					<a class="carousel-control left carousel-control-prev" href="#portfolio" data-slide="prev">
						<i class="fas fa-long-arrow-alt-left"></i>
					</a>
					<a class="carousel-control right carousel-control-next" href="#portfolio" data-slide="next">
						<i class="fas fa-long-arrow-alt-right"></i>
					</a>
				</div>
			</div>
		</div>
	</div>
	</div>
	</div>
	
	<div class="featured_products" data-aos="fade-up" data-aos-once="true">
		<div class="container">
			<div class="row center_item mb-3">
				<div class="col">
					<h2><?php  if( function_exists('get_field')) {	 echo the_field('featured_products_title');} ?></h2>
				</div>
				<div class="col text-right">
					<!-- Carousel controls -->
					<a class="carousel-control left carousel-control-prev" href="#FeaturedProducts" data-slide="prev">
						<i class="fas fa-long-arrow-alt-left"></i>
					</a>
					<a class="carousel-control right carousel-control-next" href="#FeaturedProducts" data-slide="next">
						<i class="fas fa-long-arrow-alt-right"></i>
					</a>
				</div>
			</div>
			<div id="FeaturedProducts" class="carousel slide" data-ride="carousel" data-interval="0">
				<!-- Wrapper for carousel items -->
				<div class="carousel-inner">
				
				<?php
				global $product;
					  $id=get_the_ID();
					$the_query = new WP_Query(array(
													'post_type' => 'product'													
																									
													));
													 $productno = 0;
												
										
									while ( $the_query->have_posts() ) : $the_query->the_post(); ?> 
									 <?php if ( $productno%4 == 0 ): ?>
					<div class="item carousel-item <?php if ( $productno == 0 ): ?>active<?php endif; ?>">
						<div class="row">
						 <?php endif; ?>	
							<div class="col-md-6">
								<div class="d-flex product_item center_item">
									<div class="product_img">
										<?php $imageArray = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),"full"); ?>
								<?php if(isset($imageArray[0]) && $imageArray[0]) : ?>
									<img src="<?php echo $imageArray[0]; ?>" class="w-100"  />
								<?php endif; ?> 
									</div>
									<div class="product_content">
										<div class="price"><?php echo $product->get_price_html(); ?></div>
										<a href="<?php the_permalink();?>"><h4><?php the_title();?></h4></a>
										<a href="<?php echo get_home_url(); ?>/?add-to-cart=<?php echo $id; ?>" class="add_cart">Add To Cart</a>
									</div>
									<!--<a href="#" class="wishlist"><i class="far fa-heart"></i></a>-->
								</div>
							</div>
								<?php $productno++; ?>
							 <?php if ( $productno%4 == 0 ):?>				
					
						
					
					</div>
					
					
				</div>
				 <?php endif; ?>
        <?php endwhile;   ?>
		<?php wp_reset_postdata(); ?>
			</div>
		</div>
	</div>
	</div>
	</div>
	</div>

	
	<div class="blog_block" data-aos="fade-down" data-aos-once="true">
		<div class="container">
			<div class="row">
				<div class="col-md-12 text-center">
					<div class="title_block">
						<h2><?php  if( function_exists('get_field')) {	 echo the_field('blog_posts_title');} ?></h2>
						<?php  if( function_exists('get_field')) {	 echo the_field('blog_content');} ?>
					</div>
				</div>
			</div>
			<div id="latest_blog" class="carousel slide" data-ride="carousel" data-interval="0">
				<!-- Wrapper for carousel items -->
				<div class="carousel-inner">
			<?php 
					$the_query = new WP_Query(array('post_type' => 'post', 'posts_per_page' => 18));
					$counterpost = 0;
					
					while ( $the_query->have_posts() ) : $the_query->the_post(); 
					?>
					<?php $counterpost++; ?>
					<?php $imageArray = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),"full"); ?>
					<div class="item carousel-item <?php echo ($counterpost == 1) ? 'active' : ""; ?>">
						<div class="row blog_item center_item">
							<div class="col-md-5">
					
									<img src="<?php echo get_first_image(); ?>" class="w-100"  />
							
							</div>
							<div class="col-md-7">
								<div class="inner_content">
									<h5><?php echo get_the_date( 'D M j' );?>  BY  <?php the_author();?> <span class="border_line"></span></h5>
									<a href="<?php the_permalink();?>"><h2><?php the_title();?></h2></a>
									 <p><?php echo wp_trim_words( get_the_content(), 100, '...' );?></p>
								</div>
							</div>
						</div>
					</div>
						<?php endwhile; wp_reset_postdata();?>
				</div>
				
				<!-- Carousel controls -->
				<a class="carousel-control left carousel-control-prev" href="#latest_blog" data-slide="prev">
					<i class="fas fa-long-arrow-alt-left"></i>
				</a>
				<a class="carousel-control right carousel-control-next" href="#latest_blog" data-slide="next">
					<i class="fas fa-long-arrow-alt-right"></i>
				</a>
			</div>			
			
		</div>
	</div>
	
		<?php endwhile; ?>
	<?php endif; ?>	
 
<?php get_footer(); ?>