<?php
/**
Template Name: Portfolio Page
*/

get_header(); ?>	

<section class="inner-banner">
	<div class="container">
		<div class="row">
			<?php while ( have_posts() ) : the_post(); ?>
			<div class="banner-section">
				<?php $imageArray = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),"full"); ?>
				
				<?php if(isset($imageArray[0]) && !empty($imageArray[0])) : ?>
					<img src="<?php echo $imageArray[0]; ?>" class="img-responsive">
				<?php else: ?>
					<img src="<?php echo get_stylesheet_directory_uri(); ?>/img/portfolio-bg.jpg" class="img-responsive">
				<?php endif; ?>
	 			
				<div class="banner-content-area">
					<div class="container">
						<div class="row">
							<div class="col-md-12">
								<?php if(function_exists("get_field") && get_field("banner_heading_1")) : ?>
									<h4><?php the_field("banner_heading_1"); ?></h4>
								<?php endif ?>						
								
								<h2><?php the_title(); ?></h2>
								<!--<a href="javascript:void(0)" class="call-2-more">Schedule a <span>Appointment</span></a>-->
								<nav aria-label="breadcrumb" class="float-right">
									<ol class="breadcrumb">
										<li class="breadcrumb-item"><a href="<?php bloginfo("url"); ?>">Home</a></li>
										<li class="breadcrumb-item active" aria-current="page"><?php the_title(); ?></li>
									</ol>
								</nav>
							</div>
						</div>            
					</div>                
				</div>
			</div>
		</div>
	</div>
</section>

		<section class="inner-content art-bacground">
			<div class="container">
				<div class="row center_item">
				<?php
					  $id=get_the_ID();
					$the_query = new WP_Query(array(
													'post_type' => 'portfolio',
													'posts_per_page' => 30
																																						
													));
													
										
									while ( $the_query->have_posts() ) : $the_query->the_post(); ?> 
					<div class="col-lg-3 col-md-4 col-xs-6 thumb">
					<?php $imageArray = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),"full"); ?>
								<?php if(isset($imageArray[0]) && $imageArray[0]) : ?>
		                <a href="<?php echo $imageArray[0]; ?>" class="fancybox" rel="ligthbox">
		                <img  src="<?php echo $imageArray[0]; ?>" class="zoom img-fluid "  alt="">		                   
		                </a>
						<?php endif; ?> 
		            </div>
		          
		          	 <?php wp_reset_postdata(); ?>
        <?php endwhile;   ?>
		           
		            
		        
				</div>
			</div><!-- .container -->
		</section><!-- .inner-content -->
	<?php endwhile; ?>

<?php get_footer(); ?>
