/**
 * Frontend JS implementations
 */

const locationHref = location.href;
var spread_shop_config = {
    shopName: spreadshop_config_data.spreadshopID,
    startToken: spreadshop_config_data.spreadshopToken,
    prefix: "//shop.spreadshirt."+spreadshop_config_data.spreadshopTLD,
    baseId: "myShop",
    locale: spreadshop_config_data.spreadshopLocale,
    usePushState: spreadshop_config_data.spreadshopOptimizeUrl,
    pushStateBaseUrl: locationHref,
    updateMetadata: spreadshop_config_data.spreadshopMetadata,
    swipeMenu: spreadshop_config_data.spreadshopSwipeMenu,
    integrationProvider: "Spreadshirt Wordpress plugin v1.5.1"
};

window.onload = function () {

    const currentLocation = document.URL;
    const baseUrl = window.location.protocol + "//" + window.location.hostname + "/";

    redirectShopUrl(currentLocation,baseUrl);
};

/**
 * Redirect home url to new target url
 */
function redirectShopUrl(currentLocation,baseUrl) {

    let sprdCookieUrl = decodeURIComponent(readCookie('sprdCookieUrl'));
    let sprdCookieToken = decodeURIComponent(readCookie('sprdCookieToken'));

    let shopLocation = baseUrl + sprdCookieUrl;
    let shopLocationTrailling = baseUrl + sprdCookieUrl + "/";
    let shopLocationHash = baseUrl + sprdCookieUrl + "#!/";
    let shopLocationTraillingHash = baseUrl + sprdCookieUrl + "/#!/";

    if (sprdCookieToken) {
        if((currentLocation === shopLocation) ||
            (currentLocation === shopLocationTrailling) ||
            (currentLocation === shopLocationHash) ||
            (currentLocation === shopLocationTraillingHash)) {
            window.location.href = shopLocation + "/#!/" + sprdCookieToken;
        }
    }
}

function readCookie(name) {

    let nameEQ = name + "=";
    let ca = document.cookie.split(';');

    for(let i=0;i < ca.length;i++) {

        let c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1,c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}